package com.agilex.healthcare.veteranappointment.utils.linkbuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.veteranappointment.domain.VARDomainTransferObjectCollection;

import java.net.URI;

public abstract class VARDomainLinkBuilder<Ts extends VARDomainTransferObjectCollection<T>, T extends PatientData> implements VARLinkBuilder<Ts, T> {
	private URI baseUri;

	public VARDomainLinkBuilder(URI baseUri) {
		UriDtoValidator.validate(baseUri);
		this.baseUri = baseUri;
	}

	@Override
	public void fillLinks(Ts dataList, URI requestUri) {
		if (dataList != null) {
//			UriDtoValidator.validate(dataList);

			dataList.setSelfUri(requestUri);
			fillCustomRelatedLinks(dataList);

			for (T dataItem : dataList) {
				this.fillLinks(dataItem, null);
			}
		}
	}

	@Override
	public void fillLinks(T dataItem, URI requestUri) {
		if (dataItem != null) {
			UriDtoValidator.validate(dataItem);
			UriHelper.setSelfUri(dataItem, requestUri, this.getCannonicalSelfUri(dataItem));
			fillCustomRelatedLinks(dataItem);
		}
	}

	protected URI getBaseUri() {
		return this.baseUri;
	}

//	protected URI extractPatientUri(T dataItem) {
//		return PatientUriHelper.createPatientSelfUri(dataItem.getPatientIdentifier(), baseUri);
//	}

	public abstract URI getCannonicalSelfUri(T dataItem);

	public abstract URI getCannonicalUriForCollection(URI patientUri);

	protected abstract void fillCustomRelatedLinks(T dataItem);

	protected abstract void fillCustomRelatedLinks(Ts dataList);
}
